<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AiKbDraft extends Model
{
    protected $fillable = ['ticket_id','category_id','suggested_title','suggested_excerpt','suggested_content','suggested_tags','status','published_article_id'];

    protected function casts(): array {
        return ['suggested_tags' => 'array'];
    }

    public function ticket(): BelongsTo          { return $this->belongsTo(Ticket::class); }
    public function category(): BelongsTo         { return $this->belongsTo(KbCategory::class); }
    public function publishedArticle(): BelongsTo { return $this->belongsTo(KbArticle::class, 'published_article_id'); }

    public function scopePending($q)   { return $q->where('status', 'pending'); }
    public function scopePublished($q) { return $q->where('status', 'published'); }
}
