<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AiKeywordRule extends Model
{
    protected $fillable = ['keyword','entity_type','entity_id','weight','hits','active'];
    protected function casts(): array { return ['active' => 'boolean', 'weight' => 'float']; }

    public function scopeActive($q)    { return $q->where('active', true); }
    public function scopeCategory($q)  { return $q->where('entity_type', 'category'); }
    public function scopePriority($q)  { return $q->where('entity_type', 'priority'); }
}
