<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AssetAssignment extends Model
{
    protected $fillable = ['asset_id','user_id','assigned_by','assigned_at','returned_at','reason','notes'];
    protected function casts(): array {
        return ['assigned_at' => 'date', 'returned_at' => 'date'];
    }

    public function asset(): BelongsTo      { return $this->belongsTo(Asset::class); }
    public function user(): BelongsTo       { return $this->belongsTo(User::class); }
    public function assignedBy(): BelongsTo { return $this->belongsTo(User::class, 'assigned_by'); }

    public function scopeActive($q) { return $q->whereNull('returned_at'); }
}
