<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AssetCategory extends Model
{
    protected $fillable = ['name', 'icon', 'color', 'active'];
    protected function casts(): array { return ['active' => 'boolean']; }

    public function assets(): HasMany       { return $this->hasMany(Asset::class, 'category_id'); }
    public function models(): HasMany       { return $this->hasMany(AssetModel::class, 'category_id'); }
    public function customFields(): HasMany { return $this->hasMany(AssetCustomField::class, 'category_id')->orderBy('order'); }

    public function scopeActive($q) { return $q->where('active', true)->orderBy('name'); }
}
