<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AssetCustomField extends Model
{
    protected $fillable = ['category_id','name','label','type','options','required','order'];
    protected function casts(): array {
        return ['required' => 'boolean', 'options' => 'array'];
    }

    public function category(): BelongsTo { return $this->belongsTo(AssetCategory::class); }
    public function values(): HasMany     { return $this->hasMany(AssetFieldValue::class, 'field_id'); }
}
