<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AssetIntervention extends Model
{
    protected $fillable = [
        'asset_id','technician_id','ticket_id','type','title',
        'description','cost','intervention_date','status_before','status_after'
    ];
    protected function casts(): array {
        return ['intervention_date' => 'date', 'cost' => 'decimal:2'];
    }

    public static array $types = [
        'maintenance' => 'Mantenimiento',
        'repair'      => 'Reparación',
        'upgrade'     => 'Actualización',
        'inspection'  => 'Inspección',
    ];

    public function asset(): BelongsTo      { return $this->belongsTo(Asset::class); }
    public function technician(): BelongsTo { return $this->belongsTo(User::class, 'technician_id'); }
    public function ticket(): BelongsTo     { return $this->belongsTo(Ticket::class); }

    public function getTypeLabelAttribute(): string {
        return self::$types[$this->type] ?? $this->type;
    }
}
