<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AssetManufacturer extends Model
{
    protected $fillable = ['name', 'website', 'active'];
    protected function casts(): array { return ['active' => 'boolean']; }

    public function models(): HasMany { return $this->hasMany(AssetModel::class, 'manufacturer_id'); }
    public function scopeActive($q)  { return $q->where('active', true)->orderBy('name'); }
}
