<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class AssetModel extends Model
{
    protected $fillable = ['name', 'manufacturer_id', 'category_id', 'active'];
    protected function casts(): array { return ['active' => 'boolean']; }

    public function manufacturer(): BelongsTo { return $this->belongsTo(AssetManufacturer::class); }
    public function category(): BelongsTo     { return $this->belongsTo(AssetCategory::class); }
    public function assets(): HasMany         { return $this->hasMany(Asset::class, 'model_id'); }

    public function scopeActive($q) { return $q->where('active', true)->orderBy('name'); }
}
