<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class AutomationLog extends Model
{
    public $timestamps = false;
    protected $fillable = ['rule_id','ticket_id','actions_executed','result','executed_at'];
    protected function casts(): array {
        return ['actions_executed'=>'array','executed_at'=>'datetime'];
    }
    public function rule(): BelongsTo   { return $this->belongsTo(AutomationRule::class, 'rule_id'); }
    public function ticket(): BelongsTo { return $this->belongsTo(Ticket::class); }
}
