<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class KbVote extends Model
{
    protected $fillable = ['article_id','user_id','helpful'];
    protected function casts(): array { return ['helpful' => 'boolean']; }

    public function article(): BelongsTo { return $this->belongsTo(KbArticle::class, 'article_id'); }
    public function user(): BelongsTo    { return $this->belongsTo(User::class); }
}
