<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class ReplyTemplate extends Model
{
    protected $fillable = ['name','shortcut','body','category_id','active','uses'];
    protected function casts(): array { return ['active' => 'boolean']; }

    public function category(): BelongsTo { return $this->belongsTo(TicketCategory::class); }
    public function scopeActive($q) { return $q->where('active', true)->orderBy('name'); }

    // Reemplazar variables dinámicas
    public function render(Ticket $ticket): string
    {
        return str_replace(
            ['{{ticket}}', '{{solicitante}}', '{{agente}}', '{{prioridad}}', '{{estado}}'],
            [
                $ticket->number,
                $ticket->requester->name,
                $ticket->assignee?->name ?? 'sin asignar',
                $ticket->priority->name,
                $ticket->status->name,
            ],
            $this->body
        );
    }

    public function incrementUses(): void { $this->increment('uses'); }
}
