<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Schedule extends Model
{
    protected $fillable = ['department_id', 'day_of_week', 'start_time', 'end_time', 'active'];

    protected function casts(): array {
        return ['active' => 'boolean'];
    }

    public static array $days = [
        0 => 'Domingo', 1 => 'Lunes', 2 => 'Martes',
        3 => 'Miércoles', 4 => 'Jueves', 5 => 'Viernes', 6 => 'Sábado'
    ];

    public function department(): BelongsTo {
        return $this->belongsTo(Department::class);
    }

    public function scopeActive($query) {
        return $query->where('active', true);
    }
    public function scopeForDay($query, int $day) {
        return $query->where('day_of_week', $day);
    }

    public function getDayNameAttribute(): string {
        return self::$days[$this->day_of_week] ?? '—';
    }
}
