<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class TicketAttachment extends Model
{
    protected $fillable = ['ticket_id','comment_id','user_id','original_name','stored_name','path','mime_type','size'];

    public function ticket(): BelongsTo  { return $this->belongsTo(Ticket::class); }
    public function comment(): BelongsTo { return $this->belongsTo(TicketComment::class); }
    public function user(): BelongsTo    { return $this->belongsTo(User::class); }

    public function getUrlAttribute(): string { return asset('storage/' . $this->path); }

    public function getHumanSizeAttribute(): string {
        if ($this->size < 1024)       return $this->size . ' B';
        if ($this->size < 1048576)    return round($this->size / 1024, 1) . ' KB';
        return round($this->size / 1048576, 1) . ' MB';
    }
}
