<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TicketComment extends Model
{
    use SoftDeletes;

    protected $fillable = ['ticket_id','user_id','body','is_internal'];
    protected function casts(): array { return ['is_internal' => 'boolean']; }

    public function ticket(): BelongsTo  { return $this->belongsTo(Ticket::class); }
    public function user(): BelongsTo    { return $this->belongsTo(User::class); }
    public function attachments(): HasMany { return $this->hasMany(TicketAttachment::class, 'comment_id'); }
}
