<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TicketPriority extends Model
{
    protected $fillable = ['name','level','color','badge_color','sla_response_hours','sla_resolution_hours','active'];
    protected function casts(): array { return ['active' => 'boolean', 'level' => 'integer']; }

    public function tickets(): HasMany { return $this->hasMany(Ticket::class, 'priority_id'); }
    public function scopeActive($q) { return $q->where('active', true)->orderBy('level'); }
}
