<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class TicketStatus extends Model
{
    protected $fillable = ['name','color','badge_color','is_initial','is_final','is_pending','allowed_next','order','active'];
    protected function casts(): array {
        return ['is_initial'=>'boolean','is_final'=>'boolean','is_pending'=>'boolean',
                'active'=>'boolean','allowed_next'=>'array'];
    }

    public function tickets(): HasMany { return $this->hasMany(Ticket::class, 'status_id'); }
    public function scopeActive($q) { return $q->where('active', true)->orderBy('order'); }

    public function canTransitionTo(int $nextStatusId): bool {
        if (empty($this->allowed_next)) return true;
        return in_array($nextStatusId, $this->allowed_next);
    }
}
