<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::table('users', function (Blueprint $table) {
            if (!Schema::hasColumn('users', 'phone'))
                $table->string('phone')->nullable()->after('email');
            if (!Schema::hasColumn('users', 'extension'))
                $table->string('extension')->nullable()->after('phone');
            if (!Schema::hasColumn('users', 'position'))
                $table->string('position')->nullable()->after('extension');
            if (!Schema::hasColumn('users', 'location'))
                $table->string('location')->nullable()->after('position');
            if (!Schema::hasColumn('users', 'avatar'))
                $table->string('avatar')->nullable()->after('location');
            if (!Schema::hasColumn('users', 'is_available'))
                $table->boolean('is_available')->default(true)->after('is_active');
            if (!Schema::hasColumn('users', 'department_id'))
                $table->unsignedBigInteger('department_id')->nullable()->after('is_available');
        });
    }
    public function down(): void {
        Schema::table('users', function (Blueprint $table) {
            $cols = ['phone','extension','position','location','avatar','is_available','department_id'];
            $existing = array_filter($cols, fn($c) => Schema::hasColumn('users', $c));
            if (!empty($existing)) $table->dropColumn($existing);
        });
    }
};
