<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('agent_groups', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->boolean('auto_assign')->default(false);
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
        Schema::create('agent_group_user', function (Blueprint $table) {
            $table->foreignId('agent_group_id')->constrained()->cascadeOnDelete();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->primary(['agent_group_id', 'user_id']);
        });
    }
    public function down(): void {
        Schema::dropIfExists('agent_group_user');
        Schema::dropIfExists('agent_groups');
    }
};
