<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('ai_response_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->text('trigger_keywords'); // JSON array de keywords que activan esta plantilla
            $table->foreignId('category_id')->nullable()->constrained('ticket_categories')->nullOnDelete();
            $table->string('ticket_type')->nullable(); // consulta, incidente, solicitud, etc.
            $table->text('template_body'); // Plantilla con {{variables}}
            $table->integer('min_confidence')->default(50); // Confianza mínima para activarse
            $table->integer('uses')->default(0);
            $table->integer('accepted')->default(0); // Cuántas veces fue aceptada por agentes
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('ai_response_templates'); }
};
