<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('ai_kb_drafts', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ticket_id')->constrained()->cascadeOnDelete();
            $table->foreignId('category_id')->nullable()->constrained('kb_categories')->nullOnDelete();
            $table->string('suggested_title');
            $table->text('suggested_excerpt');
            $table->longText('suggested_content');
            $table->json('suggested_tags')->nullable();
            $table->enum('status', ['pending','published','rejected'])->default('pending');
            $table->foreignId('published_article_id')->nullable()->constrained('kb_articles')->nullOnDelete();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('ai_kb_drafts'); }
};
