<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('ticket_priorities', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->tinyInteger('level')->default(1); // 1=baja 2=media 3=alta 4=crítica
            $table->string('color', 7)->default('#6C757D');
            $table->string('badge_color', 30)->default('bg-gray-100 text-gray-800');
            $table->integer('sla_response_hours')->default(24);
            $table->integer('sla_resolution_hours')->default(72);
            $table->boolean('active')->default(true);
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('ticket_priorities'); }
};
