<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('tickets', function (Blueprint $table) {
            $table->id();
            $table->string('number')->unique(); // TKT-0001
            $table->string('title');
            $table->longText('description');
            $table->foreignId('status_id')->constrained('ticket_statuses');
            $table->foreignId('priority_id')->constrained('ticket_priorities');
            $table->foreignId('category_id')->nullable()->constrained('ticket_categories')->nullOnDelete();
            $table->foreignId('type_id')->nullable()->constrained('ticket_types')->nullOnDelete();
            $table->foreignId('requester_id')->constrained('users'); // quien abre
            $table->foreignId('assignee_id')->nullable()->constrained('users')->nullOnDelete(); // agente
            $table->foreignId('department_id')->nullable()->constrained('departments')->nullOnDelete();
            $table->foreignId('asset_id')->nullable(); // se activará en Sprint 4
            $table->timestamp('sla_response_due')->nullable();
            $table->timestamp('sla_resolution_due')->nullable();
            $table->boolean('sla_response_breached')->default(false);
            $table->boolean('sla_resolution_breached')->default(false);
            $table->timestamp('first_response_at')->nullable();
            $table->timestamp('resolved_at')->nullable();
            $table->timestamp('closed_at')->nullable();
            $table->tinyInteger('satisfaction_score')->nullable(); // 1-5
            $table->text('satisfaction_comment')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->index(['status_id', 'priority_id']);
            $table->index(['assignee_id', 'status_id']);
            $table->index('requester_id');
        });
    }
    public function down(): void { Schema::dropIfExists('tickets'); }
};
