<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('assets', function (Blueprint $table) {
            $table->id();
            $table->string('code')->unique(); // ACT-0001
            $table->string('name');
            $table->string('serial_number')->nullable();
            $table->foreignId('category_id')->constrained('asset_categories');
            $table->foreignId('model_id')->nullable()->constrained('asset_models')->nullOnDelete();
            $table->string('status')->default('active');
            // active | in_repair | in_storage | decommissioned | on_loan
            $table->string('location')->nullable();
            $table->foreignId('department_id')->nullable()->constrained('departments')->nullOnDelete();
            $table->foreignId('assigned_to')->nullable()->constrained('users')->nullOnDelete();
            $table->date('purchase_date')->nullable();
            $table->decimal('purchase_price', 12, 2)->nullable();
            $table->date('warranty_until')->nullable();
            $table->text('notes')->nullable();
            $table->string('qr_code')->nullable(); // path al QR generado
            $table->timestamps();
            $table->softDeletes();
            $table->index(['status', 'category_id']);
            $table->index('assigned_to');
        });
    }
    public function down(): void { Schema::dropIfExists('assets'); }
};
