<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('asset_interventions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('asset_id')->constrained()->cascadeOnDelete();
            $table->foreignId('technician_id')->constrained('users');
            $table->foreignId('ticket_id')->nullable()->constrained('tickets')->nullOnDelete();
            $table->string('type'); // maintenance, repair, upgrade, inspection
            $table->string('title');
            $table->text('description');
            $table->decimal('cost', 10, 2)->nullable();
            $table->date('intervention_date');
            $table->string('status_before')->nullable();
            $table->string('status_after')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('asset_interventions'); }
};
