<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('nexus_notifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->string('type');
            // ticket_created, ticket_assigned, ticket_updated, ticket_comment,
            // ticket_status_changed, ticket_closed, sla_warning, sla_breached
            $table->string('title');
            $table->text('body');
            $table->string('url')->nullable();
            $table->string('icon')->default('bell');
            $table->string('color')->default('blue');
            $table->timestamp('read_at')->nullable();
            $table->timestamps();
            $table->index(['user_id', 'read_at']);
        });
    }
    public function down(): void { Schema::dropIfExists('nexus_notifications'); }
};
