<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('kb_articles', function (Blueprint $table) {
            $table->id();
            $table->string('title');
            $table->string('slug')->unique();
            $table->longText('content');           // HTML del editor
            $table->text('excerpt')->nullable();   // Resumen corto para buscador
            $table->foreignId('category_id')->nullable()->constrained('kb_categories')->nullOnDelete();
            $table->foreignId('author_id')->constrained('users');
            $table->string('status')->default('draft'); // draft | published | archived
            $table->boolean('featured')->default(false);
            $table->integer('views')->default(0);
            $table->integer('helpful_yes')->default(0);
            $table->integer('helpful_no')->default(0);
            $table->string('tags')->nullable(); // CSV de tags
            $table->timestamp('published_at')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->fullText(['title', 'excerpt']); // búsqueda full-text
        });
    }
    public function down(): void { Schema::dropIfExists('kb_articles'); }
};
