<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('system_settings', function (Blueprint $table) {
            $table->id();
            $table->string('group')->default('general');
            $table->string('key')->unique();
            $table->longText('value')->nullable();
            $table->string('type')->default('string'); // string|boolean|integer|json|text
            $table->string('label')->nullable();
            $table->timestamps();
            $table->index('group');
        });
    }
    public function down(): void { Schema::dropIfExists('system_settings'); }
};
