<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('business_hours', function (Blueprint $table) {
            $table->id();
            $table->tinyInteger('day_of_week'); // 0=Dom, 1=Lun...6=Sab
            $table->boolean('active')->default(true);
            $table->time('opens_at')->default('08:00:00');
            $table->time('closes_at')->default('17:00:00');
            $table->timestamps();
            $table->unique('day_of_week');
        });
    }
    public function down(): void { Schema::dropIfExists('business_hours'); }
};
