<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('automation_rules', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('description')->nullable();
            $table->string('trigger');
            // ticket_created | ticket_updated | status_changed | sla_warning | sla_breached | ticket_idle
            $table->json('conditions'); // [["field","operator","value"], ...]
            $table->json('actions');    // [["type","params"], ...]
            $table->boolean('active')->default(true);
            $table->integer('order')->default(0);
            $table->integer('executions')->default(0);
            $table->timestamp('last_executed_at')->nullable();
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('automation_rules'); }
};
