<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('reply_templates', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('shortcut')->nullable()->unique(); // /saludo
            $table->text('body');
            $table->foreignId('category_id')->nullable()->constrained('ticket_categories')->nullOnDelete();
            $table->boolean('active')->default(true);
            $table->integer('uses')->default(0);
            $table->timestamps();
        });
    }
    public function down(): void { Schema::dropIfExists('reply_templates'); }
};
