<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('automation_logs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('rule_id')->constrained('automation_rules')->cascadeOnDelete();
            $table->foreignId('ticket_id')->constrained()->cascadeOnDelete();
            $table->json('actions_executed');
            $table->string('result')->default('success'); // success | partial | failed
            $table->timestamp('executed_at');
            $table->index(['rule_id','executed_at']);
        });
    }
    public function down(): void { Schema::dropIfExists('automation_logs'); }
};
