<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('ai_classifications', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ticket_id')->constrained()->cascadeOnDelete();
            $table->foreignId('suggested_category_id')->nullable()->constrained('ticket_categories')->nullOnDelete();
            $table->foreignId('suggested_priority_id')->nullable()->constrained('ticket_priorities')->nullOnDelete();
            $table->decimal('category_confidence', 5, 2)->default(0); // 0-100%
            $table->decimal('priority_confidence', 5, 2)->default(0);
            $table->json('kb_suggestions')->nullable(); // [{id, title, slug, score}]
            $table->json('keywords_detected')->nullable();
            $table->boolean('applied')->default(false); // Si el agente aceptó la sugerencia
            $table->timestamps();
            $table->unique('ticket_id');
        });
    }
    public function down(): void { Schema::dropIfExists('ai_classifications'); }
};
