<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void {
        Schema::create('ai_keyword_rules', function (Blueprint $table) {
            $table->id();
            $table->string('keyword');
            $table->string('entity_type'); // category | priority
            $table->unsignedBigInteger('entity_id');
            $table->decimal('weight', 5, 2)->default(1.0); // 0.1 - 5.0
            $table->integer('hits')->default(0); // cuántas veces acertó
            $table->boolean('active')->default(true);
            $table->timestamps();
            $table->index(['entity_type','entity_id']);
        });
    }
    public function down(): void { Schema::dropIfExists('ai_keyword_rules'); }
};
