<?php
namespace Database\Seeders;

use App\Models\AiResponseTemplate;
use App\Models\TicketCategory;
use Illuminate\Database\Seeder;

class AiResponseTemplateSeeder extends Seeder
{
    public function run(): void
    {
        $cats = TicketCategory::all()->keyBy(fn($c) => strtolower($c->name));
        $find = fn(array $hints) => $cats->first(fn($c,$k) => collect($hints)->contains(fn($h) => str_contains($k, $h)));

        $templates = [
            [
                'name'             => 'Reset de contraseña',
                'trigger_keywords' => ['contrasena','password','clave','no puedo entrar','bloqueado','acceso'],
                'category'         => ['acceso','contrasena','password'],
                'template_body'    =>
"Hola {{solicitante}},

Gracias por contactarnos. Para restablecer tu contraseña, sigue estos pasos:

1. Ve a la página de inicio de sesión
2. Haz clic en \"¿Olvidaste tu contraseña?\"
3. Ingresa tu correo corporativo
4. Revisa tu bandeja de entrada y sigue el enlace recibido

Si el problema persiste o tu cuenta está bloqueada, un administrador deberá desbloquearte manualmente. En ese caso, avísanos y lo gestionamos a la brevedad.

Quedo atento a cualquier consulta adicional.

Saludos,
{{agente}} | Soporte {{empresa}}",
                'min_confidence'   => 30,
            ],
            [
                'name'             => 'Equipo lento / rendimiento bajo',
                'trigger_keywords' => ['lento','tarda','demora','lentitud','rendimiento','pesado'],
                'category'         => ['hardware','equipo','pc'],
                'template_body'    =>
"Hola {{solicitante}},

Entendemos que tu equipo está presentando problemas de rendimiento. Aquí algunos pasos que pueden ayudar:

**Solución inmediata:**
1. Reinicia el equipo completamente (no solo hibernar)
2. Cierra las aplicaciones que no estés usando
3. Verifica que el equipo tenga al menos 10% de espacio libre en disco
4. Revisa si hay actualizaciones pendientes de Windows/macOS

**Si el problema continúa:**
Coordinaremos una revisión técnica de tu equipo para diagnosticar si requiere limpieza de hardware, ampliación de memoria RAM o mantenimiento del sistema.

¿Cuándo tienes disponibilidad para que un técnico revise tu equipo?

Saludos,
{{agente}} | Soporte {{empresa}}",
                'min_confidence'   => 25,
            ],
            [
                'name'             => 'Problema de conexión a internet/red',
                'trigger_keywords' => ['internet','red','wifi','sin conexion','no conecta','conexion','vpn'],
                'category'         => ['red','conectividad','internet'],
                'template_body'    =>
"Hola {{solicitante}},

Para resolver tu problema de conectividad, por favor intenta lo siguiente:

**Pasos básicos:**
1. Reinicia el router/switch de tu área (desconectar 30 segundos)
2. En tu equipo: Inicio → CMD → escribe `ipconfig /release` luego `ipconfig /renew`
3. Si usas WiFi, intenta conectarte por cable y verifica si el problema persiste
4. Desactiva y vuelve a activar el adaptador de red

**Si usas VPN:**
Desconéctate de la VPN, verifica la conexión directa, y luego vuelve a conectar.

Si ninguno de estos pasos funciona, dime tu número de extensión o ubicación para que un técnico revise el punto de red físicamente.

Saludos,
{{agente}} | Soporte {{empresa}}",
                'min_confidence'   => 25,
            ],
            [
                'name'             => 'Error en aplicación / software',
                'trigger_keywords' => ['error','programa','aplicacion','no abre','falla','crash','cierra solo'],
                'category'         => ['software','aplicacion','programa'],
                'template_body'    =>
"Hola {{solicitante}},

Gracias por reportar el problema con tu aplicación. Para ayudarte mejor necesito algunos datos:

1. ¿Cuál es el mensaje de error exacto que aparece? (si tienes captura de pantalla, adjúntala)
2. ¿El error ocurre siempre o de forma intermitente?
3. ¿Cuándo comenzó el problema? ¿Hubo alguna actualización o cambio previo?

**Mientras tanto, puedes intentar:**
- Cerrar y volver a abrir la aplicación
- Reiniciar tu equipo
- Si es una app web, limpiar caché del navegador (Ctrl+Shift+Del)

Con esa información podremos darte una solución más precisa o escalar al área correspondiente.

Saludos,
{{agente}} | Soporte {{empresa}}",
                'min_confidence'   => 20,
            ],
            [
                'name'             => 'Problema con impresora',
                'trigger_keywords' => ['impresora','imprimir','imprime','papel','toner','cartucho'],
                'category'         => ['hardware','equipo','impresora'],
                'template_body'    =>
"Hola {{solicitante}},

Para resolver el problema con la impresora, por favor verifica:

1. **¿La impresora está encendida?** Revisa que el indicador de luz esté verde
2. **¿Hay papel?** Revisa que la bandeja tenga papel y esté bien colocado
3. **Trabajos atascados:** En Windows ve a Panel de Control → Dispositivos e impresoras → clic derecho en tu impresora → Ver trabajos de impresión → elimina todos los trabajos pendientes
4. **Reinicia la impresora:** Apágala, espera 30 segundos, enciéndela nuevamente

Si el problema es de toner/cartucho, coordinaremos el reemplazo.

¿Cuál es el modelo de impresora y qué error específico aparece?

Saludos,
{{agente}} | Soporte {{empresa}}",
                'min_confidence'   => 20,
            ],
        ];

        foreach ($templates as $t) {
            $catHints = $t['category'];
            $cat      = $find($catHints);

            AiResponseTemplate::firstOrCreate(
                ['name' => $t['name']],
                [
                    'trigger_keywords' => $t['trigger_keywords'],
                    'category_id'      => $cat?->id,
                    'template_body'    => $t['template_body'],
                    'min_confidence'   => $t['min_confidence'],
                    'active'           => true,
                ]
            );
        }

        echo '  AiResponseTemplateSeeder: ' . AiResponseTemplate::count() . " plantillas creadas\n";
    }
}
