<?php
namespace Database\Seeders;

use App\Models\AssetCategory;
use App\Models\AssetCustomField;
use App\Models\AssetManufacturer;
use Illuminate\Database\Seeder;

class AssetConfigSeeder extends Seeder
{
    public function run(): void
    {
        // Fabricantes
        $manufacturers = ['Dell','HP','Lenovo','Apple','Samsung','Cisco','TP-Link','Brother','Epson','LG'];
        foreach ($manufacturers as $m) {
            AssetManufacturer::firstOrCreate(['name' => $m]);
        }

        // Categorías con campos personalizados
        $categories = [
            [
                'name' => 'Computadores', 'icon' => 'desktop', 'color' => '#2E86AB',
                'fields' => [
                    ['label'=>'Procesador',    'name'=>'cpu',       'type'=>'text'],
                    ['label'=>'RAM (GB)',       'name'=>'ram',       'type'=>'number'],
                    ['label'=>'Disco (GB)',     'name'=>'storage',   'type'=>'number'],
                    ['label'=>'S.O.',           'name'=>'os',        'type'=>'text'],
                    ['label'=>'Dirección IP',   'name'=>'ip',        'type'=>'text'],
                    ['label'=>'Dirección MAC',  'name'=>'mac',       'type'=>'text'],
                ],
            ],
            [
                'name' => 'Servidores', 'icon' => 'server', 'color' => '#1E3A5F',
                'fields' => [
                    ['label'=>'CPU',            'name'=>'cpu',       'type'=>'text'],
                    ['label'=>'RAM (GB)',        'name'=>'ram',       'type'=>'number'],
                    ['label'=>'Almacenamiento',  'name'=>'storage',   'type'=>'text'],
                    ['label'=>'IP',             'name'=>'ip',        'type'=>'text'],
                    ['label'=>'Sistema Operativo','name'=>'os',       'type'=>'text'],
                    ['label'=>'Rol del servidor','name'=>'role',      'type'=>'text'],
                ],
            ],
            [
                'name' => 'Impresoras', 'icon' => 'printer', 'color' => '#27AE60',
                'fields' => [
                    ['label'=>'Tipo',           'name'=>'type',      'type'=>'text'],
                    ['label'=>'IP',             'name'=>'ip',        'type'=>'text'],
                    ['label'=>'Tóner / Tinta',  'name'=>'toner',     'type'=>'text'],
                ],
            ],
            [
                'name' => 'Red y Comunicaciones', 'icon' => 'wifi', 'color' => '#8E44AD',
                'fields' => [
                    ['label'=>'IP de gestión',  'name'=>'mgmt_ip',   'type'=>'text'],
                    ['label'=>'Puertos',        'name'=>'ports',     'type'=>'number'],
                    ['label'=>'VLAN',           'name'=>'vlan',      'type'=>'text'],
                ],
            ],
            [
                'name' => 'Móviles y Tablets', 'icon' => 'phone', 'color' => '#F39C12',
                'fields' => [
                    ['label'=>'IMEI',           'name'=>'imei',      'type'=>'text'],
                    ['label'=>'Número',         'name'=>'phone_num', 'type'=>'text'],
                    ['label'=>'S.O.',           'name'=>'os',        'type'=>'text'],
                ],
            ],
            [
                'name' => 'Licencias de Software', 'icon' => 'key', 'color' => '#E74C3C',
                'fields' => [
                    ['label'=>'Clave de licencia', 'name'=>'key',    'type'=>'text'],
                    ['label'=>'Seats',          'name'=>'seats',     'type'=>'number'],
                    ['label'=>'Versión',        'name'=>'version',   'type'=>'text'],
                    ['label'=>'Vencimiento',    'name'=>'expires',   'type'=>'date'],
                ],
            ],
            [
                'name' => 'Mobiliario', 'icon' => 'office', 'color' => '#95A5A6',
                'fields' => [],
            ],
        ];

        foreach ($categories as $catData) {
            $fields = $catData['fields'];
            unset($catData['fields']);
            $cat = AssetCategory::firstOrCreate(['name' => $catData['name']], $catData);

            foreach ($fields as $i => $field) {
                AssetCustomField::firstOrCreate(
                    ['category_id' => $cat->id, 'name' => $field['name']],
                    array_merge($field, ['category_id' => $cat->id, 'order' => $i])
                );
            }
        }
    }
}
