<?php
namespace Database\Seeders;

use App\Models\Configuration;
use Illuminate\Database\Seeder;

class ConfigurationSeeder extends Seeder
{
    public function run(): void
    {
        $configs = [
            // General
            ['key' => 'app_name',           'value' => 'NEXUS',                         'group' => 'general',    'type' => 'text',    'label' => 'Nombre del sistema',         'is_public' => true],
            ['key' => 'app_company',         'value' => 'Mi Empresa S.A.S',              'group' => 'general',    'type' => 'text',    'label' => 'Nombre de la empresa',       'is_public' => true],
            ['key' => 'app_phone',           'value' => '',                              'group' => 'general',    'type' => 'text',    'label' => 'Teléfono de soporte',        'is_public' => true],
            ['key' => 'app_email_support',   'value' => 'soporte@miempresa.com',         'group' => 'general',    'type' => 'email',   'label' => 'Email de soporte',           'is_public' => true],
            ['key' => 'tickets_per_page',    'value' => '20',                            'group' => 'general',    'type' => 'number',  'label' => 'Tickets por página',         'is_public' => false],
            // Correo
            ['key' => 'mail_from_name',      'value' => 'NEXUS Service Desk',            'group' => 'mail',       'type' => 'text',    'label' => 'Nombre remitente email'],
            ['key' => 'mail_from_address',   'value' => 'soporte@miempresa.com',         'group' => 'mail',       'type' => 'text',    'label' => 'Email remitente'],
            ['key' => 'mail_notify_new',     'value' => '1',                             'group' => 'mail',       'type' => 'boolean', 'label' => 'Notificar ticket nuevo'],
            ['key' => 'mail_notify_assign',  'value' => '1',                             'group' => 'mail',       'type' => 'boolean', 'label' => 'Notificar asignación'],
            ['key' => 'mail_notify_resolve', 'value' => '1',                             'group' => 'mail',       'type' => 'boolean', 'label' => 'Notificar ticket resuelto'],
            // Apariencia
            ['key' => 'ui_primary_color',    'value' => '#1E3A5F',                       'group' => 'appearance', 'type' => 'color',   'label' => 'Color primario'],
            ['key' => 'ui_accent_color',     'value' => '#2E86AB',                       'group' => 'appearance', 'type' => 'color',   'label' => 'Color de acento'],
            // SLA
            ['key' => 'sla_low_response',    'value' => '24',                            'group' => 'sla',        'type' => 'number',  'label' => 'Horas respuesta — Baja',     'description' => 'horas'],
            ['key' => 'sla_low_resolve',     'value' => '72',                            'group' => 'sla',        'type' => 'number',  'label' => 'Horas resolución — Baja',    'description' => 'horas'],
            ['key' => 'sla_medium_response', 'value' => '8',                             'group' => 'sla',        'type' => 'number',  'label' => 'Horas respuesta — Media'],
            ['key' => 'sla_medium_resolve',  'value' => '24',                            'group' => 'sla',        'type' => 'number',  'label' => 'Horas resolución — Media'],
            ['key' => 'sla_high_response',   'value' => '2',                             'group' => 'sla',        'type' => 'number',  'label' => 'Horas respuesta — Alta'],
            ['key' => 'sla_high_resolve',    'value' => '8',                             'group' => 'sla',        'type' => 'number',  'label' => 'Horas resolución — Alta'],
            ['key' => 'sla_critical_response','value' => '1',                            'group' => 'sla',        'type' => 'number',  'label' => 'Horas respuesta — Crítica'],
            ['key' => 'sla_critical_resolve', 'value' => '4',                            'group' => 'sla',        'type' => 'number',  'label' => 'Horas resolución — Crítica'],
            // Tickets
            ['key' => 'ticket_allow_reopen', 'value' => '1',                             'group' => 'tickets',    'type' => 'boolean', 'label' => 'Permitir reabrir tickets'],
            ['key' => 'ticket_reopen_days',  'value' => '7',                             'group' => 'tickets',    'type' => 'number',  'label' => 'Días para reabrir',          'description' => 'días después del cierre'],
            ['key' => 'ticket_auto_close',   'value' => '5',                             'group' => 'tickets',    'type' => 'number',  'label' => 'Auto-cerrar resueltos en',   'description' => 'días sin respuesta del usuario'],
            ['key' => 'ticket_satisfaction', 'value' => '1',                             'group' => 'tickets',    'type' => 'boolean', 'label' => 'Encuesta de satisfacción'],
        ];

        foreach ($configs as $config) {
            Configuration::firstOrCreate(
                ['key' => $config['key']],
                array_merge($config, ['is_public' => $config['is_public'] ?? false])
            );
        }
    }
}
