<?php
namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;

class DatabaseSeeder extends Seeder
{
    public function run(): void
    {
        $this->call([
            RoleSeeder::class,
            DepartmentSeeder::class,
            ConfigurationSeeder::class,
        ]);

        // Usuario superadmin
        $superadmin = User::firstOrCreate(
            ['email' => 'admin@evolucionamos.com'],
            [
                'name'     => 'Administrador NEXUS',
                'password' => bcrypt('Admin2026*'),
                'is_active' => true,
            ]
        );
        $superadmin->syncRoles(['superadmin']);

        // Usuario agente de prueba
        $agente = User::firstOrCreate(
            ['email' => 'agente@evolucionamos.com'],
            [
                'name'     => 'Agente Soporte',
                'password' => bcrypt('Admin2026*'),
                'is_active' => true,
                'position' => 'Técnico de Soporte',
            ]
        );
        $agente->syncRoles(['agente']);

        // Usuario final de prueba
        $usuario = User::firstOrCreate(
            ['email' => 'usuario@evolucionamos.com'],
            [
                'name'     => 'Usuario Final',
                'password' => bcrypt('Admin2026*'),
                'is_active' => true,
            ]
        );
        $usuario->syncRoles(['usuario']);
    }
}
