<?php
namespace Database\Seeders;

use App\Models\Department;
use Illuminate\Database\Seeder;

class DepartmentSeeder extends Seeder
{
    public function run(): void
    {
        $departments = [
            ['name' => 'Tecnología e Innovación', 'color' => '#2E86AB', 'description' => 'Infraestructura, desarrollo y soporte técnico'],
            ['name' => 'Administración y Finanzas', 'color' => '#27AE60', 'description' => 'Gestión administrativa y financiera'],
            ['name' => 'Operaciones', 'color' => '#F39C12', 'description' => 'Procesos operativos y logística'],
            ['name' => 'Talento Humano', 'color' => '#8E44AD', 'description' => 'Gestión del recurso humano'],
            ['name' => 'Comercial', 'color' => '#E74C3C', 'description' => 'Ventas y relaciones con clientes'],
        ];

        foreach ($departments as $dept) {
            Department::firstOrCreate(['name' => $dept['name']], $dept);
        }
    }
}
