<?php
namespace Database\Seeders;

use App\Models\KbArticle;
use App\Models\KbCategory;
use App\Models\User;
use Illuminate\Database\Seeder;

class KbSeeder extends Seeder
{
    public function run(): void
    {
        $author = User::role('superadmin')->first() ?? User::first();

        $cats = [
            ['name'=>'Accesos y Contraseñas', 'icon'=>'key',       'color'=>'#E74C3C', 'desc'=>'Guías para gestión de cuentas y accesos'],
            ['name'=>'Correo Electrónico',     'icon'=>'mail',      'color'=>'#2E86AB', 'desc'=>'Configuración y uso del correo corporativo'],
            ['name'=>'Conectividad y Red',     'icon'=>'wifi',      'color'=>'#27AE60', 'desc'=>'Problemas de red, internet y VPN'],
            ['name'=>'Equipos y Hardware',     'icon'=>'desktop',   'color'=>'#F39C12', 'desc'=>'Guías para equipos, impresoras y periféricos'],
            ['name'=>'Software y Aplicaciones','icon'=>'code',      'color'=>'#8E44AD', 'desc'=>'Instalación y uso de aplicaciones'],
            ['name'=>'Seguridad',              'icon'=>'shield',    'color'=>'#E67E22', 'desc'=>'Buenas prácticas de seguridad informática'],
        ];

        foreach ($cats as $c) {
            $desc = $c['desc'];
            unset($c['desc']);
            KbCategory::firstOrCreate(['name' => $c['name']], array_merge($c, [
                'slug'        => \Illuminate\Support\Str::slug($c['name']),
                'description' => $desc,
            ]));
        }

        // Artículo de bienvenida
        $cat = KbCategory::first();
        if (KbArticle::count() === 0 && $author) {
            KbArticle::create([
                'title'        => '¿Cómo restablecer mi contraseña?',
                'content'      => '<h2>Pasos para restablecer tu contraseña</h2>
<p>Si olvidaste tu contraseña o necesitas cambiarla, sigue estos pasos:</p>
<ol>
  <li>Ve a la página de inicio de sesión</li>
  <li>Haz clic en "¿Olvidaste tu contraseña?"</li>
  <li>Ingresa tu correo corporativo</li>
  <li>Revisa tu bandeja de entrada y sigue el enlace recibido</li>
  <li>Crea una nueva contraseña segura (mínimo 8 caracteres, mayúsculas, números y símbolos)</li>
</ol>
<blockquote><strong>Importante:</strong> Si no recibes el correo en 5 minutos, revisa la carpeta de spam o crea un ticket de soporte.</blockquote>',
                'category_id'  => $cat?->id,
                'author_id'    => $author->id,
                'status'       => 'published',
                'featured'     => true,
                'tags'         => 'contraseña, acceso, login',
                'published_at' => now(),
            ]);
        }
    }
}
