<?php
namespace Database\Seeders;

use App\Models\AutomationRule;
use App\Models\BusinessHour;
use App\Models\ReplyTemplate;
use App\Models\SystemSetting;
use Illuminate\Database\Seeder;

class Sprint7Seeder extends Seeder
{
    public function run(): void
    {
        // Configuración inicial
        $defaults = [
            ['general', 'app_name',          'NEXUS Service Desk',            'string'],
            ['general', 'app_tagline',        'Gestión de soporte técnico',    'string'],
            ['branding','app_primary_color',  '#2563EB',                       'string'],
            ['general', 'support_email',      'soporte@evolucionamos.com',     'string'],
            ['tickets', 'tickets_per_page',   '20',                            'integer'],
            ['tickets', 'auto_close_days',    '7',                             'integer'],
            ['sla',     'sla_pauses_outside', '0',                             'boolean'],
            ['portal',  'welcome_message',    '¿En qué podemos ayudarte hoy?', 'text'],
        ];
        foreach ($defaults as [$group, $key, $value, $type]) {
            SystemSetting::firstOrCreate(['key' => $key], compact('group','key','value','type'));
        }

        // Horarios Lun-Vie 8am-5pm
        for ($dow = 0; $dow <= 6; $dow++) {
            BusinessHour::firstOrCreate(['day_of_week' => $dow], [
                'active'    => in_array($dow, [1,2,3,4,5]),
                'opens_at'  => '08:00:00',
                'closes_at' => '17:00:00',
            ]);
        }

        // Plantillas de respuesta
        $templates = [
            [
                'name'     => 'Saludo inicial',
                'shortcut' => '/saludo',
                'body'     => 'Hola {{solicitante}}, hemos recibido tu ticket {{ticket}} y lo estamos revisando. Te mantendremos informado. Gracias por contactarnos.',
            ],
            [
                'name'     => 'Solicitar información adicional',
                'shortcut' => '/info',
                'body'     => 'Hola {{solicitante}}, para ayudarte con el ticket {{ticket}}, necesitamos información adicional. ¿Podrías indicar los pasos exactos y cualquier mensaje de error?',
            ],
            [
                'name'     => 'Resolución confirmada',
                'shortcut' => '/resuelto',
                'body'     => 'Hola {{solicitante}}, hemos resuelto el ticket {{ticket}}. Por favor confirma si el problema fue resuelto satisfactoriamente.',
            ],
            [
                'name'     => 'En progreso',
                'shortcut' => '/progreso',
                'body'     => 'Hola {{solicitante}}, tu ticket {{ticket}} está en progreso. El agente {{agente}} está trabajando en ello y te notificaremos pronto.',
            ],
            [
                'name'     => 'Pendiente usuario',
                'shortcut' => '/pendiente',
                'body'     => 'Hola {{solicitante}}, tu ticket {{ticket}} requiere tu confirmación o información adicional para continuar. Por favor responde cuando puedas.',
            ],
        ];
        foreach ($templates as $t) {
            ReplyTemplate::firstOrCreate(['shortcut' => $t['shortcut']], $t);
        }

        // Regla de ejemplo
        AutomationRule::firstOrCreate(['name' => 'Escalar SLA incumplido'], [
            'description' => 'Notifica a supervisores cuando un ticket incumple el SLA',
            'trigger'     => 'sla_breached',
            'conditions'  => [],
            'actions'     => [
                ['type' => 'escalate',    'params' => []],
                ['type' => 'add_comment', 'params' => [
                    'body' => 'Este ticket ha incumplido el SLA. Se ha notificado al equipo supervisor.',
                ]],
            ],
            'active' => true,
            'order'  => 1,
        ]);
    }
}
