<?php
namespace Database\Seeders;

use App\Models\TicketCategory;
use App\Models\TicketPriority;
use App\Models\TicketStatus;
use App\Models\TicketType;
use Illuminate\Database\Seeder;

class TicketConfigSeeder extends Seeder
{
    public function run(): void
    {
        // ── Prioridades ───────────────────────────────────────────────────────
        $priorities = [
            ['name'=>'Baja',    'level'=>1,'color'=>'#6C757D','sla_response_hours'=>24,'sla_resolution_hours'=>72],
            ['name'=>'Media',   'level'=>2,'color'=>'#2E86AB','sla_response_hours'=>8, 'sla_resolution_hours'=>24],
            ['name'=>'Alta',    'level'=>3,'color'=>'#F39C12','sla_response_hours'=>2, 'sla_resolution_hours'=>8],
            ['name'=>'Crítica', 'level'=>4,'color'=>'#E74C3C','sla_response_hours'=>1, 'sla_resolution_hours'=>4],
        ];
        foreach ($priorities as $p) {
            TicketPriority::firstOrCreate(['name' => $p['name']], $p);
        }

        // ── Estados ───────────────────────────────────────────────────────────
        $statuses = [
            ['name'=>'Nuevo',              'color'=>'#2E86AB','is_initial'=>true, 'is_final'=>false,'is_pending'=>false,'order'=>1],
            ['name'=>'Asignado',           'color'=>'#8E44AD','is_initial'=>false,'is_final'=>false,'is_pending'=>false,'order'=>2],
            ['name'=>'En Progreso',        'color'=>'#F39C12','is_initial'=>false,'is_final'=>false,'is_pending'=>false,'order'=>3],
            ['name'=>'Pendiente Usuario',  'color'=>'#E67E22','is_initial'=>false,'is_final'=>false,'is_pending'=>true, 'order'=>4],
            ['name'=>'Resuelto',           'color'=>'#27AE60','is_initial'=>false,'is_final'=>false,'is_pending'=>false,'order'=>5],
            ['name'=>'Cerrado',            'color'=>'#6C757D','is_initial'=>false,'is_final'=>true, 'is_pending'=>false,'order'=>6],
        ];
        foreach ($statuses as $s) {
            TicketStatus::firstOrCreate(['name' => $s['name']], $s);
        }

        // ── Tipos ─────────────────────────────────────────────────────────────
        $types = ['Incidente','Solicitud de Servicio','Problema','Cambio','Consulta'];
        foreach ($types as $t) {
            TicketType::firstOrCreate(['name' => $t]);
        }

        // ── Categorías ────────────────────────────────────────────────────────
        $categories = [
            ['name'=>'Hardware',    'color'=>'#E74C3C','children'=>['Computadores','Impresoras','Periféricos','Servidores']],
            ['name'=>'Software',    'color'=>'#2E86AB','children'=>['Sistema Operativo','Office / Productividad','Aplicaciones internas','Correo electrónico']],
            ['name'=>'Red',         'color'=>'#27AE60','children'=>['Internet','Wi-Fi','VPN','Conectividad interna']],
            ['name'=>'Accesos',     'color'=>'#F39C12','children'=>['Creación de usuario','Reseteo de contraseña','Permisos','Bloqueo de cuenta']],
            ['name'=>'Otros',       'color'=>'#6C757D','children'=>[]],
        ];
        foreach ($categories as $cat) {
            $parent = TicketCategory::firstOrCreate(
                ['name' => $cat['name']],
                ['color' => $cat['color'], 'active' => true]
            );
            foreach ($cat['children'] as $child) {
                TicketCategory::firstOrCreate(
                    ['name' => $child, 'parent_id' => $parent->id],
                    ['color' => $cat['color'], 'active' => true]
                );
            }
        }
    }
}
