@extends('layouts.app')
@section('title', 'Auditoría')
@section('content')
<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Auditoría del Sistema</h1>
    <p class="text-sm text-gray-500 mt-1">Registro completo de actividad</p>
</div>

@php
    $logs = \Spatie\Activitylog\Models\Activity::with('causer')
        ->latest()
        ->paginate(25);
@endphp

<div class="bg-white rounded-xl shadow-sm border border-gray-200">
    <div class="overflow-x-auto">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Fecha</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Usuario</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Acción</th>
                    <th class="px-6 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Descripción</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                @forelse($logs as $log)
                <tr class="hover:bg-gray-50">
                    <td class="px-6 py-4 text-xs text-gray-500 whitespace-nowrap">
                        {{ $log->created_at->format('d/m/Y H:i') }}
                    </td>
                    <td class="px-6 py-4 text-sm text-gray-700">
                        {{ $log->causer?->name ?? 'Sistema' }}
                    </td>
                    <td class="px-6 py-4">
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                            {{ $log->event === 'created' ? 'bg-green-100 text-green-800' :
                               ($log->event === 'updated' ? 'bg-blue-100 text-blue-800' :
                               ($log->event === 'deleted' ? 'bg-red-100 text-red-800' : 'bg-gray-100 text-gray-800')) }}">
                            {{ ucfirst($log->event ?? 'evento') }}
                        </span>
                    </td>
                    <td class="px-6 py-4 text-sm text-gray-600">
                        {{ $log->description }}
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="4" class="px-6 py-12 text-center text-gray-400 text-sm">
                        No hay registros de actividad aún.
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
    @if($logs->hasPages())
    <div class="px-6 py-4 border-t border-gray-200">
        {{ $logs->links() }}
    </div>
    @endif
</div>
@endsection
