@extends('layouts.app')
@section('title', 'Automatizaciones')
@section('content')

@if(session('success'))
<div class="mb-4 p-3 bg-green-50 border border-green-200 rounded-xl text-green-800 text-sm">✓ {{ session('success') }}</div>
@endif

<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Reglas de Automatización</h1>
        <p class="text-sm text-gray-500 mt-1">Acciones automáticas basadas en eventos de tickets</p>
    </div>
    <a href="{{ route('admin.automations.create') }}"
       class="px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
        + Nueva regla
    </a>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
<div class="lg:col-span-2">

{{-- Lista de reglas --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 divide-y divide-gray-100">
    @forelse($rules as $rule)
    <div class="p-5 flex items-start gap-4">
        <div class="flex-shrink-0 mt-0.5">
            <span class="h-3 w-3 rounded-full inline-block {{ $rule->active ? 'bg-green-500' : 'bg-gray-300' }}"></span>
        </div>
        <div class="flex-1 min-w-0">
            <div class="flex items-center gap-2 mb-1">
                <h3 class="text-sm font-semibold text-gray-900">{{ $rule->name }}</h3>
                <span class="text-xs px-2 py-0.5 rounded-full bg-blue-100 text-blue-700">
                    {{ \App\Models\AutomationRule::$triggers[$rule->trigger] ?? $rule->trigger }}
                </span>
            </div>
            @if($rule->description)
            <p class="text-xs text-gray-500 mb-2">{{ $rule->description }}</p>
            @endif
            <div class="flex items-center gap-4 text-xs text-gray-400">
                <span>{{ count($rule->conditions) }} condicion(es)</span>
                <span>{{ count($rule->actions) }} acción(es)</span>
                <span>{{ $rule->executions }} ejecuciones</span>
                @if($rule->last_executed_at)
                <span>Última: {{ $rule->last_executed_at->diffForHumans() }}</span>
                @endif
            </div>
        </div>
        <div class="flex items-center gap-2 flex-shrink-0">
            <form method="POST" action="{{ route('admin.automations.toggle', $rule) }}">
                @csrf @method('PATCH')
                <button type="submit"
                        class="px-2.5 py-1 text-xs rounded-lg {{ $rule->active ? 'bg-green-100 text-green-700' : 'bg-gray-100 text-gray-500' }} hover:opacity-80 transition">
                    {{ $rule->active ? 'Activa' : 'Inactiva' }}
                </button>
            </form>
            <a href="{{ route('admin.automations.edit', $rule) }}"
               class="px-2.5 py-1 text-xs bg-gray-100 text-gray-700 rounded-lg hover:bg-gray-200 transition">
                Editar
            </a>
            <form method="POST" action="{{ route('admin.automations.destroy', $rule) }}"
                  onsubmit="return confirm('¿Eliminar esta regla?')">
                @csrf @method('DELETE')
                <button type="submit" class="px-2.5 py-1 text-xs bg-red-50 text-red-600 rounded-lg hover:bg-red-100 transition">
                    ✕
                </button>
            </form>
        </div>
    </div>
    @empty
    <div class="p-12 text-center text-gray-400 text-sm">
        No hay reglas de automatización.
        <a href="{{ route('admin.automations.create') }}" class="text-blue-600 hover:underline">Crear la primera</a>
    </div>
    @endforelse
</div>

</div>

{{-- Log reciente --}}
<div>
    <h3 class="text-sm font-semibold text-gray-700 mb-3">Ejecuciones recientes</h3>
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 divide-y divide-gray-100">
        @forelse($recentLogs as $log)
        <div class="px-4 py-3">
            <div class="flex items-center justify-between mb-0.5">
                <span class="text-xs font-medium text-gray-900 truncate max-w-36">{{ $log->rule->name }}</span>
                <span class="text-xs {{ $log->result === 'success' ? 'text-green-600' : 'text-red-500' }}">
                    {{ $log->result === 'success' ? '✓' : '✗' }}
                </span>
            </div>
            <p class="text-xs text-gray-500">
                <a href="{{ route('tickets.show', $log->ticket) }}" class="text-blue-600 hover:underline">
                    {{ $log->ticket->number }}
                </a>
                · {{ $log->executed_at->diffForHumans() }}
            </p>
        </div>
        @empty
        <div class="p-6 text-center text-gray-400 text-xs">Sin ejecuciones aún</div>
        @endforelse
    </div>
</div>
</div>
@endsection
