@extends('layouts.app')
@section('title', 'Plantillas de Respuesta')
@section('content')

@if(session('success'))
<div class="mb-4 p-3 bg-green-50 border border-green-200 rounded-xl text-green-800 text-sm">✓ {{ session('success') }}</div>
@endif

<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Plantillas de Respuesta</h1>
        <p class="text-sm text-gray-500 mt-1">Respuestas predefinidas con variables dinámicas</p>
    </div>
</div>

<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">

{{-- Lista --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 divide-y divide-gray-100">
    @forelse($templates as $tpl)
    <div class="p-4">
        <div class="flex items-start justify-between gap-3">
            <div class="flex-1">
                <div class="flex items-center gap-2 mb-1">
                    <p class="text-sm font-medium text-gray-900">{{ $tpl->name }}</p>
                    @if($tpl->shortcut)
                    <span class="text-xs bg-blue-100 text-blue-700 px-1.5 py-0.5 rounded font-mono">{{ $tpl->shortcut }}</span>
                    @endif
                    @if(!$tpl->active)
                    <span class="text-xs text-gray-400">(inactiva)</span>
                    @endif
                </div>
                <p class="text-xs text-gray-500 line-clamp-2">{{ $tpl->body }}</p>
                <p class="text-xs text-gray-400 mt-1">{{ $tpl->uses }} usos</p>
            </div>
            <div class="flex gap-1 flex-shrink-0">
                <button onclick="editTemplate({{ $tpl->id }}, '{{ addslashes($tpl->name) }}', '{{ addslashes($tpl->shortcut ?? '') }}', {{ $tpl->category_id ?? 'null' }}, '{{ addslashes($tpl->body) }}')"
                        class="px-2 py-1 text-xs bg-gray-100 text-gray-700 rounded hover:bg-gray-200 transition">
                    Editar
                </button>
                <form method="POST" action="{{ route('admin.reply-templates.destroy', $tpl) }}"
                      onsubmit="return confirm('¿Eliminar?')">
                    @csrf @method('DELETE')
                    <button type="submit" class="px-2 py-1 text-xs bg-red-50 text-red-600 rounded hover:bg-red-100 transition">✕</button>
                </form>
            </div>
        </div>
    </div>
    @empty
    <div class="p-8 text-center text-gray-400 text-sm">Sin plantillas aún</div>
    @endforelse
</div>

{{-- Crear / Editar --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
    <h3 id="form-title" class="text-sm font-semibold text-gray-900 mb-4">Nueva plantilla</h3>
    <form id="template-form" method="POST" action="{{ route('admin.reply-templates.store') }}">
        @csrf
        <input type="hidden" id="form-method" name="_method" value="">
        <div class="space-y-3">
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Nombre *</label>
                <input type="text" name="name" id="tpl-name"
                       placeholder="Ej: Saludo inicial"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Atajo (shortcut)</label>
                <input type="text" name="shortcut" id="tpl-shortcut"
                       placeholder="/saludo"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <p class="text-xs text-gray-400 mt-0.5">Escribe el atajo en el comentario para autocompletar</p>
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Contenido *</label>
                <textarea name="body" id="tpl-body" rows="5"
                          placeholder="Hola {{solicitante}}, hemos recibido tu ticket {{ticket}}..."
                          class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500"></textarea>
                <p class="text-xs text-gray-400 mt-0.5">
                    Variables: <code>{{ticket}}</code> <code>{{solicitante}}</code> <code>{{agente}}</code> <code>{{prioridad}}</code> <code>{{estado}}</code>
                </p>
            </div>
        </div>
        <div class="flex gap-2 mt-4">
            <button type="submit" class="px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                Guardar
            </button>
            <button type="button" onclick="resetForm()"
                    class="px-4 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition">
                Cancelar
            </button>
        </div>
    </form>
</div>
</div>
@endsection

<script>
function editTemplate(id, name, shortcut, catId, body) {
    document.getElementById('form-title').textContent = 'Editar plantilla';
    document.getElementById('template-form').action = '/admin/reply-templates/' + id;
    document.getElementById('form-method').value = 'PATCH';
    document.getElementById('tpl-name').value = name;
    document.getElementById('tpl-shortcut').value = shortcut;
    document.getElementById('tpl-body').value = body;
    window.scrollTo({top: 0, behavior: 'smooth'});
}
function resetForm() {
    document.getElementById('form-title').textContent = 'Nueva plantilla';
    document.getElementById('template-form').action = '{{ route("admin.reply-templates.store") }}';
    document.getElementById('form-method').value = '';
    document.getElementById('template-form').reset();
}
</script>
