@extends('layouts.app')
@section('title', 'Configuración del Sistema')
@section('content')

@if(session('success'))
<div class="mb-4 p-3 bg-green-50 border border-green-200 rounded-xl text-green-800 text-sm">✓ {{ session('success') }}</div>
@endif

<div class="mb-6">
    <h1 class="text-2xl font-bold text-gray-900">Configuración del Sistema</h1>
    <p class="text-sm text-gray-500 mt-1">Branding, portal, horarios de atención y comportamiento de tickets</p>
</div>

<div class="grid grid-cols-1 lg:grid-cols-3 gap-6">
<div class="lg:col-span-2 space-y-6">

{{-- Branding --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
    <h2 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">🎨 Branding</h2>
    <form method="POST" action="{{ route('admin.settings.update') }}">
        @csrf @method('PATCH')
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Nombre del sistema</label>
                <input type="text" name="app_name"
                       value="{{ $settings['app_name']->value ?? 'NEXUS Service Desk' }}"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Tagline</label>
                <input type="text" name="app_tagline"
                       value="{{ $settings['app_tagline']->value ?? 'Gestión de soporte técnico' }}"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Color primario</label>
                <div class="flex gap-2 items-center">
                    <input type="color" name="app_primary_color"
                           value="{{ $settings['app_primary_color']->value ?? '#2563EB' }}"
                           class="h-9 w-16 rounded border-gray-300 cursor-pointer">
                    <span class="text-xs text-gray-500">Color de botones y acentos</span>
                </div>
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">URL del logo</label>
                <input type="url" name="app_logo_url"
                       value="{{ $settings['app_logo_url']->value ?? '' }}"
                       placeholder="https://..."
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Email de soporte</label>
                <input type="email" name="support_email"
                       value="{{ $settings['support_email']->value ?? '' }}"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Teléfono de soporte</label>
                <input type="text" name="support_phone"
                       value="{{ $settings['support_phone']->value ?? '' }}"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
        </div>
        <div class="mt-4">
            <label class="block text-xs font-medium text-gray-700 mb-1">Mensaje de bienvenida del portal</label>
            <textarea name="welcome_message" rows="2"
                      class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">{{ $settings['welcome_message']->value ?? '¿En qué podemos ayudarte hoy?' }}</textarea>
        </div>
        <button type="submit" class="mt-4 px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            Guardar branding
        </button>
    </form>
</div>

{{-- Tickets --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
    <h2 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">🎫 Comportamiento de Tickets</h2>
    <form method="POST" action="{{ route('admin.settings.update') }}">
        @csrf @method('PATCH')
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Tickets por página</label>
                <input type="number" name="tickets_per_page" min="10" max="100"
                       value="{{ $settings['tickets_per_page']->value ?? 20 }}"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            <div>
                <label class="block text-xs font-medium text-gray-700 mb-1">Auto-cerrar tickets resueltos (días)</label>
                <input type="number" name="auto_close_days" min="0" max="90"
                       value="{{ $settings['auto_close_days']->value ?? 7 }}"
                       class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <p class="text-xs text-gray-400 mt-0.5">0 = desactivado</p>
            </div>
        </div>
        <div class="mt-4">
            <label class="flex items-center gap-2 cursor-pointer">
                <input type="checkbox" name="sla_pauses_outside" value="1"
                       {{ ($settings['sla_pauses_outside']->value ?? '0') === '1' ? 'checked' : '' }}
                       class="rounded border-gray-300 text-blue-600">
                <span class="text-sm text-gray-700">Pausar SLA fuera de horario laboral</span>
            </label>
        </div>
        <button type="submit" class="mt-4 px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            Guardar
        </button>
    </form>
</div>

{{-- Horarios de atención --}}
<div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
    <h2 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">🕐 Horarios de Atención</h2>
    <form method="POST" action="{{ route('admin.settings.hours') }}">
        @csrf
        <div class="space-y-3">
            @foreach(\App\Models\BusinessHour::$days as $dow => $dayName)
            @php $hour = $hours[$dow] ?? null @endphp
            <div class="flex items-center gap-4">
                <div class="w-28">
                    <label class="flex items-center gap-2 cursor-pointer">
                        <input type="checkbox" name="day_{{ $dow }}_active" value="1"
                               {{ $hour?->active ? 'checked' : '' }}
                               class="rounded border-gray-300 text-blue-600">
                        <span class="text-sm text-gray-700">{{ $dayName }}</span>
                    </label>
                </div>
                <input type="time" name="day_{{ $dow }}_opens"
                       value="{{ $hour?->opens_at ?? '08:00' }}"
                       class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                <span class="text-xs text-gray-400">a</span>
                <input type="time" name="day_{{ $dow }}_closes"
                       value="{{ $hour?->closes_at ?? '17:00' }}"
                       class="rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
            </div>
            @endforeach
        </div>
        <button type="submit" class="mt-4 px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
            Guardar horarios
        </button>
    </form>
</div>

</div>

{{-- Panel lateral --}}
<div class="space-y-5">
    {{-- Estado actual del sistema --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h3 class="text-sm font-semibold text-gray-900 mb-4">Estado del sistema</h3>
        @php $isOpen = \App\Models\BusinessHour::isBusinessHours() @endphp
        <div class="flex items-center gap-2 mb-4">
            <span class="h-3 w-3 rounded-full {{ $isOpen ? 'bg-green-500' : 'bg-gray-400' }}"></span>
            <span class="text-sm font-medium {{ $isOpen ? 'text-green-700' : 'text-gray-500' }}">
                {{ $isOpen ? 'En horario laboral' : 'Fuera de horario' }}
            </span>
        </div>
        <dl class="space-y-2 text-xs">
            <div class="flex justify-between">
                <dt class="text-gray-500">Laravel</dt>
                <dd class="font-medium">{{ app()->version() }}</dd>
            </div>
            <div class="flex justify-between">
                <dt class="text-gray-500">PHP</dt>
                <dd class="font-medium">{{ PHP_VERSION }}</dd>
            </div>
            <div class="flex justify-between">
                <dt class="text-gray-500">Entorno</dt>
                <dd class="font-medium">{{ app()->environment() }}</dd>
            </div>
        </dl>
    </div>

    {{-- Accesos rápidos de configuración --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <h3 class="text-sm font-semibold text-gray-900 mb-3">Configuración adicional</h3>
        <div class="space-y-2">
            <a href="{{ route('admin.automations.index') }}"
               class="flex items-center gap-2 p-2.5 rounded-lg hover:bg-gray-50 transition text-sm text-gray-700">
                <span>⚡</span> Reglas de automatización
            </a>
            <a href="{{ route('admin.reply-templates.index') }}"
               class="flex items-center gap-2 p-2.5 rounded-lg hover:bg-gray-50 transition text-sm text-gray-700">
                <span>💬</span> Plantillas de respuesta
            </a>
            <a href="{{ route('kb.admin.index') }}"
               class="flex items-center gap-2 p-2.5 rounded-lg hover:bg-gray-50 transition text-sm text-gray-700">
                <span>📚</span> Base de conocimiento
            </a>
            <a href="{{ route('asset-categories.index') }}"
               class="flex items-center gap-2 p-2.5 rounded-lg hover:bg-gray-50 transition text-sm text-gray-700">
                <span>🖥️</span> Categorías de activos
            </a>
        </div>
    </div>
</div>
</div>
@endsection
