@extends('layouts.app')
@section('title', 'Categorías de Tickets')
@section('content')
<div class="flex items-center gap-3 mb-6">
    <a href="{{ route('admin.settings') }}" class="text-gray-400 hover:text-gray-600">
        <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
        </svg>
    </a>
    <h1 class="text-2xl font-bold text-gray-900">Categorías de Tickets</h1>
</div>
<div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
    {{-- Formulario --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <h3 class="text-sm font-semibold text-gray-900 mb-4">Nueva Categoría</h3>
        <form method="POST" action="{{ route('ticket-categories.store') }}">
            @csrf
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Nombre <span class="text-red-500">*</span></label>
                    <input type="text" name="name" value="{{ old('name') }}"
                           class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                </div>
                <div class="grid grid-cols-2 gap-3">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Categoría padre</label>
                        <select name="parent_id" class="w-full rounded-lg border-gray-300 text-sm">
                            <option value="">— Raíz —</option>
                            @foreach($categories as $cat)
                            <option value="{{ $cat->id }}">{{ $cat->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">Color</label>
                        <input type="color" name="color" value="#2E86AB"
                               class="h-10 w-full rounded-lg border-gray-300 cursor-pointer">
                    </div>
                </div>
                <button type="submit"
                        class="w-full py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                    Crear Categoría
                </button>
            </div>
        </form>
    </div>
    {{-- Lista --}}
    <div class="bg-white rounded-xl shadow-sm border border-gray-200">
        <div class="px-6 py-4 border-b border-gray-200">
            <h3 class="text-sm font-semibold text-gray-900">Categorías ({{ $categories->count() }})</h3>
        </div>
        <div class="divide-y divide-gray-100">
            @forelse($categories as $cat)
            <div class="px-6 py-3 flex items-center justify-between">
                <div class="flex items-center gap-3">
                    <div class="h-3 w-3 rounded-full" style="background-color: {{ $cat->color }}"></div>
                    <span class="text-sm font-medium text-gray-900">{{ $cat->name }}</span>
                    @if($cat->children->count() > 0)
                    <span class="text-xs text-gray-400">({{ $cat->children->count() }} sub)</span>
                    @endif
                </div>
                <form method="POST" action="{{ route('ticket-categories.destroy', $cat) }}">
                    @csrf @method('DELETE')
                    <button type="submit" class="text-xs text-red-500 hover:text-red-700"
                            onclick="return confirm('¿Eliminar {{ $cat->name }}?')">
                        Eliminar
                    </button>
                </form>
            </div>
            @foreach($cat->children as $child)
            <div class="px-6 py-2 flex items-center justify-between bg-gray-50">
                <div class="flex items-center gap-3 pl-4">
                    <span class="text-gray-300">└</span>
                    <div class="h-2 w-2 rounded-full" style="background-color: {{ $child->color }}"></div>
                    <span class="text-sm text-gray-700">{{ $child->name }}</span>
                </div>
            </div>
            @endforeach
            @empty
            <div class="px-6 py-8 text-center text-gray-400 text-sm">Sin categorías creadas.</div>
            @endforelse
        </div>
    </div>
</div>
@endsection
