@extends('layouts.app')
@section('title', 'Grupos de Agentes')
@section('content')
<div class="flex items-center justify-between mb-6">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">Grupos de Agentes</h1>
        <p class="text-sm text-gray-500 mt-1">Organiza los agentes por especialidad para asignación automática</p>
    </div>
    @can('agent_groups.create')
    <a href="{{ route('grupos-agentes.create') }}"
       class="inline-flex items-center px-4 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
        <svg class="h-4 w-4 mr-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"/>
        </svg>
        Nuevo Grupo
    </a>
    @endcan
</div>

<div class="space-y-3">
    @forelse($groups as $group)
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
        <div class="flex items-center justify-between">
            <div class="flex items-center gap-4">
                <div class="h-10 w-10 rounded-lg bg-blue-50 flex items-center justify-center">
                    <svg class="h-5 w-5 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2"
                              d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"/>
                    </svg>
                </div>
                <div>
                    <div class="flex items-center gap-2">
                        <h3 class="text-sm font-semibold text-gray-900">{{ $group->name }}</h3>
                        @if($group->auto_assign)
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-purple-100 text-purple-800">
                            Auto-asignación
                        </span>
                        @endif
                    </div>
                    @if($group->description)
                    <p class="text-xs text-gray-500 mt-0.5">{{ $group->description }}</p>
                    @endif
                    <div class="flex items-center gap-2 mt-2">
                        @forelse($group->users->take(5) as $user)
                        <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium bg-gray-100 text-gray-700">
                            {{ $user->name }}
                        </span>
                        @empty
                        <span class="text-xs text-gray-400">Sin agentes asignados</span>
                        @endforelse
                        @if($group->users->count() > 5)
                        <span class="text-xs text-gray-400">+{{ $group->users->count() - 5 }} más</span>
                        @endif
                    </div>
                </div>
            </div>
            <div class="flex items-center gap-3">
                <span class="inline-flex items-center px-2 py-0.5 rounded-full text-xs font-medium
                    {{ $group->active ? 'bg-green-100 text-green-800' : 'bg-red-100 text-red-800' }}">
                    {{ $group->active ? 'Activo' : 'Inactivo' }}
                </span>
                @can('agent_groups.edit')
                <a href="{{ route('grupos-agentes.edit', $group) }}"
                   class="text-blue-600 hover:text-blue-800 text-sm font-medium">Editar</a>
                @endcan
                @can('agent_groups.delete')
                <form method="POST" action="{{ route('grupos-agentes.destroy', $group) }}"
                      onsubmit="return confirm('¿Eliminar grupo {{ $group->name }}?')">
                    @csrf @method('DELETE')
                    <button type="submit" class="text-red-600 hover:text-red-800 text-sm font-medium">Eliminar</button>
                </form>
                @endcan
            </div>
        </div>
    </div>
    @empty
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-12 text-center text-gray-400 text-sm">
        No hay grupos de agentes creados aún.
    </div>
    @endforelse
</div>
@endsection
