@extends('layouts.app')
@section('title','Revisar borrador KB')
@section('content')

<div class="mb-6 flex items-center justify-between">
    <div>
        <h1 class="text-xl font-bold text-gray-900">Revisar borrador — IA</h1>
        <p class="text-sm text-gray-500 mt-1">Generado desde ticket <a href="{{ route('tickets.show', $draft->ticket) }}" class="text-blue-600">{{ $draft->ticket->number }}</a></p>
    </div>
    <a href="{{ route('ai.kb-drafts') }}" class="text-sm text-blue-600 hover:underline">← Borradores</a>
</div>

<form method="POST" action="{{ route('ai.kb-drafts.publish', $draft) }}">
    @csrf
    <div class="grid grid-cols-3 gap-6">
        <div class="col-span-2 space-y-5">

            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
                <h2 class="text-sm font-semibold text-gray-700 mb-4">Contenido del artículo</h2>
                <div class="space-y-4">
                    <div>
                        <label class="block text-xs font-medium text-gray-700 mb-1">Título</label>
                        <input type="text" name="title" value="{{ old('title', $draft->suggested_title) }}"
                               class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:ring-2 focus:ring-blue-500 focus:border-transparent" required>
                    </div>
                    <div>
                        <label class="block text-xs font-medium text-gray-700 mb-1">Resumen / Excerpt</label>
                        <textarea name="excerpt" rows="2"
                                  class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm focus:ring-2 focus:ring-blue-500 resize-none" required>{{ old('excerpt', $draft->suggested_excerpt) }}</textarea>
                    </div>
                    <div>
                        <label class="block text-xs font-medium text-gray-700 mb-1">Contenido completo (Markdown)</label>
                        <textarea name="content" rows="18"
                                  class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm font-mono focus:ring-2 focus:ring-blue-500" required>{{ old('content', $draft->suggested_content) }}</textarea>
                    </div>
                </div>
            </div>

        </div>

        <div class="space-y-5">
            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
                <h2 class="text-sm font-semibold text-gray-700 mb-4">Configuración</h2>
                <div class="space-y-3">
                    <div>
                        <label class="block text-xs font-medium text-gray-700 mb-1">Categoría KB</label>
                        <select name="category_id" class="w-full border border-gray-300 rounded-lg px-3 py-2 text-sm">
                            <option value="">Sin categoría</option>
                            @foreach($categories as $cat)
                            <option value="{{ $cat->id }}" {{ old('category_id', $draft->category_id) == $cat->id ? 'selected' : '' }}>
                                {{ $cat->name }}
                            </option>
                            @endforeach
                        </select>
                    </div>
                    @if(!empty($draft->suggested_tags))
                    <div>
                        <p class="text-xs font-medium text-gray-700 mb-1">Tags sugeridos</p>
                        <div class="flex flex-wrap gap-1">
                            @foreach($draft->suggested_tags as $tag)
                            <span class="text-xs bg-blue-50 text-blue-600 px-2 py-0.5 rounded">{{ $tag }}</span>
                            @endforeach
                        </div>
                    </div>
                    @endif
                </div>
            </div>

            <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-5">
                <h2 class="text-sm font-semibold text-gray-700 mb-3">Ticket original</h2>
                <p class="text-xs font-medium text-gray-900 mb-1">{{ $draft->ticket->title }}</p>
                <p class="text-xs text-gray-500 line-clamp-3">{{ $draft->ticket->description }}</p>
            </div>

            <button type="submit"
                    class="w-full py-2.5 bg-green-600 text-white text-sm font-medium rounded-xl hover:bg-green-700 transition">
                📚 Publicar en Base de Conocimiento
            </button>
        </div>
    </div>
</form>
@endsection
