@extends('layouts.app')
@section('title','Borradores KB — IA')
@section('content')

<div class="mb-6 flex items-center justify-between">
    <div>
        <h1 class="text-2xl font-bold text-gray-900">📝 Borradores KB generados por IA</h1>
        <p class="text-sm text-gray-500 mt-1">Artículos sugeridos automáticamente al cerrar tickets</p>
    </div>
    <a href="{{ route('ai.admin') }}" class="text-sm text-blue-600 hover:underline">← IA Admin</a>
</div>

@if(session('success'))
<div class="mb-4 p-3 bg-green-50 border border-green-200 rounded-lg text-sm text-green-700">{{ session('success') }}</div>
@endif

<div class="bg-white rounded-xl shadow-sm border border-gray-200 overflow-hidden">
    @forelse($drafts as $draft)
    <div class="p-5 border-b border-gray-100 last:border-0">
        <div class="flex items-start justify-between gap-4">
            <div class="flex-1 min-w-0">
                <div class="flex items-center gap-2 mb-1">
                    <a href="{{ route('tickets.show', $draft->ticket) }}" class="text-xs text-blue-600 font-mono">{{ $draft->ticket->number }}</a>
                    @if($draft->category)<span class="text-xs bg-gray-100 text-gray-600 px-2 py-0.5 rounded">{{ $draft->category->name }}</span>@endif
                    <span class="text-xs text-gray-400">{{ $draft->created_at->diffForHumans() }}</span>
                </div>
                <h3 class="text-sm font-semibold text-gray-900 mb-1">{{ $draft->suggested_title }}</h3>
                <p class="text-xs text-gray-500 line-clamp-2">{{ $draft->suggested_excerpt }}</p>
                @if(!empty($draft->suggested_tags))
                <div class="flex flex-wrap gap-1 mt-2">
                    @foreach($draft->suggested_tags as $tag)
                    <span class="text-xs bg-blue-50 text-blue-600 px-1.5 py-0.5 rounded">{{ $tag }}</span>
                    @endforeach
                </div>
                @endif
            </div>
            <div class="flex items-center gap-2 flex-shrink-0">
                <a href="{{ route('ai.kb-drafts.edit', $draft) }}"
                   class="px-3 py-1.5 text-xs bg-green-600 text-white rounded-lg hover:bg-green-700 transition">
                    ✓ Revisar y publicar
                </a>
                <button onclick="rejectDraft({{ $draft->id }}, this)"
                        class="px-3 py-1.5 text-xs bg-gray-100 text-gray-600 rounded-lg hover:bg-gray-200 transition">
                    ✗ Descartar
                </button>
            </div>
        </div>
    </div>
    @empty
    <div class="p-12 text-center text-gray-400">
        <p class="text-4xl mb-3">📭</p>
        <p class="text-sm">No hay borradores pendientes. Se generarán automáticamente al cerrar tickets.</p>
    </div>
    @endforelse
</div>

{{ $drafts->links() }}

@endsection
<script>
function rejectDraft(id, btn) {
    btn.disabled = true;
    fetch('/ai/kb-drafts/' + id + '/reject', {
        method: 'POST',
        headers: {'Content-Type':'application/json','X-CSRF-TOKEN':document.querySelector('meta[name="csrf-token"]').content}
    }).then(r=>r.json()).then(d=>{
        if (d.success) btn.closest('.border-b').remove();
    }).catch(()=>{ btn.disabled=false; });
}
</script>
