@extends('layouts.app')
@section('title', 'Nuevo Activo')
@section('content')
<div class="max-w-3xl">
    <div class="flex items-center gap-3 mb-6">
        <a href="{{ route('assets.index') }}" class="text-gray-400 hover:text-gray-600">
            <svg class="h-5 w-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"/>
            </svg>
        </a>
        <h1 class="text-2xl font-bold text-gray-900">Nuevo Activo</h1>
    </div>
    <div class="bg-white rounded-xl shadow-sm border border-gray-200 p-6">
        <form method="POST" action="{{ route('assets.store') }}">
            @csrf
            <div class="space-y-6">

                {{-- Información básica --}}
                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">
                        Información básica
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Nombre <span class="text-red-500">*</span></label>
                            <input type="text" name="name" value="{{ old('name') }}"
                                   placeholder="Ej: Laptop Dell Inspiron 15"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500 @error('name') border-red-500 @enderror">
                            @error('name') <p class="text-red-500 text-xs mt-1">{{ $message }}</p> @enderror
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Categoría <span class="text-red-500">*</span></label>
                            <select name="category_id" id="category_id"
                                    class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500"
                                    onchange="loadModels(this.value)">
                                <option value="">— Selecciona —</option>
                                @foreach($categories as $cat)
                                <option value="{{ $cat->id }}" {{ old('category_id') == $cat->id ? 'selected' : '' }}>
                                    {{ $cat->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Modelo</label>
                            <select name="model_id" id="model_id"
                                    class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                                <option value="">— Selecciona categoría primero —</option>
                                @foreach($categories as $cat)
                                    @foreach($cat->models as $model)
                                    <option value="{{ $model->id }}"
                                            data-category="{{ $cat->id }}"
                                            {{ old('model_id') == $model->id ? 'selected' : '' }}
                                            style="display:none">
                                        {{ $model->manufacturer?->name }} {{ $model->name }}
                                    </option>
                                    @endforeach
                                @endforeach
                            </select>
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Número de serie</label>
                            <input type="text" name="serial_number" value="{{ old('serial_number') }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Estado <span class="text-red-500">*</span></label>
                            <select name="status" class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                                @foreach(\App\Models\Asset::$statuses as $key => $s)
                                <option value="{{ $key }}" {{ old('status','active') === $key ? 'selected' : '' }}>
                                    {{ $s['label'] }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                {{-- Ubicación y asignación --}}
                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">
                        Ubicación y asignación
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Ubicación física</label>
                            <input type="text" name="location" value="{{ old('location') }}"
                                   placeholder="Ej: Piso 2, Oficina 204"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Departamento</label>
                            <select name="department_id" class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                                <option value="">— Sin departamento —</option>
                                @foreach($departments as $dept)
                                <option value="{{ $dept->id }}" {{ old('department_id') == $dept->id ? 'selected' : '' }}>
                                    {{ $dept->name }}
                                </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="md:col-span-2">
                            <label class="block text-sm font-medium text-gray-700 mb-1">Asignado a</label>
                            <select name="assigned_to" class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                                <option value="">— Sin asignar —</option>
                                @foreach($users as $user)
                                <option value="{{ $user->id }}" {{ old('assigned_to') == $user->id ? 'selected' : '' }}>
                                    {{ $user->name }} ({{ $user->getRoleNames()->first() }})
                                </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>

                {{-- Datos de compra --}}
                <div>
                    <h3 class="text-sm font-semibold text-gray-900 mb-4 pb-2 border-b border-gray-100">
                        Datos de adquisición
                    </h3>
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Fecha de compra</label>
                            <input type="date" name="purchase_date" value="{{ old('purchase_date') }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Valor de compra</label>
                            <input type="number" name="purchase_price" value="{{ old('purchase_price') }}"
                                   step="0.01" placeholder="0.00"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                        <div>
                            <label class="block text-sm font-medium text-gray-700 mb-1">Garantía hasta</label>
                            <input type="date" name="warranty_until" value="{{ old('warranty_until') }}"
                                   class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">
                        </div>
                    </div>
                </div>

                {{-- Notas --}}
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Notas adicionales</label>
                    <textarea name="notes" rows="3"
                              class="w-full rounded-lg border-gray-300 text-sm focus:ring-blue-500 focus:border-blue-500">{{ old('notes') }}</textarea>
                </div>

            </div>

            <div class="flex gap-3 mt-6 pt-5 border-t border-gray-100">
                <button type="submit"
                        class="px-5 py-2 bg-blue-600 text-white text-sm font-medium rounded-lg hover:bg-blue-700 transition">
                    Crear Activo
                </button>
                <a href="{{ route('assets.index') }}"
                   class="px-5 py-2 bg-gray-100 text-gray-700 text-sm font-medium rounded-lg hover:bg-gray-200 transition">
                    Cancelar
                </a>
            </div>
        </form>
    </div>
</div>

<script>
function loadModels(categoryId) {
    const select = document.getElementById('model_id');
    const options = select.querySelectorAll('option[data-category]');
    options.forEach(opt => {
        opt.style.display = opt.dataset.category === categoryId ? '' : 'none';
    });
    select.value = '';
}
</script>
@endsection
